<?php
// FIX 1: Add this line to allow requests from the frontend
require_once '../config/cors.php';

require_once '../config/database.php';
require_once '../middleware/auth.php';
require_once '../utils/jwt.php';
require_once '../utils/admin_helper.php';

// --- AUTHENTICATION DISABLED FOR TESTING ---
/*
// Get the authorization header
$headers = getallheaders();
$token = isset($headers['Authorization']) ? str_replace('Bearer ', '', $headers['Authorization']) : null;

if (!$token) {
    http_response_code(401);
    echo json_encode(['error' => 'No token provided']);
    exit;
}

// Validate admin access
$admin = ensureAdminAccess($token);
*/
// --- END OF DISABLED CODE ---


// FIX 2: Add database connection and convert to PDO
$database = new Database();
$db = $database->getConnection();


// Handle different HTTP methods
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        try {
            // List all orders or get a specific order
            $id = isset($_GET['id']) ? $_GET['id'] : null;
            
            if ($id) {
                $stmt = $db->prepare("
                    SELECT o.*, 
                           u.name as user_name,
                           u.email as user_email,
                           a.address_line1,
                           a.address_line2,
                           a.city,
                           a.state,
                           a.postal_code,
                           a.country
                    FROM orders o
                    JOIN users u ON o.user_id = u.id
                    LEFT JOIN addresses a ON o.shipping_address_id = a.id
                    WHERE o.id = :id
                ");
                $stmt->bindParam(':id', $id);
            } else {
                // Get all orders with basic information
                $stmt = $db->prepare("
                    SELECT o.*, 
                           u.name as user_name,
                           u.email as user_email
                    FROM orders o
                    JOIN users u ON o.user_id = u.id
                    ORDER BY o.created_at DESC
                ");
            }
            
            $stmt->execute();
            $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            if ($id && !empty($orders)) {
                // If getting a specific order, also get its items
                $itemsStmt = $db->prepare("
                    SELECT oi.*, 
                           p.name as product_name,
                           p.sku as product_sku,
                           pv.variant_name
                    FROM order_items oi
                    JOIN products p ON oi.product_id = p.id
                    LEFT JOIN product_variants pv ON oi.variant_id = pv.id
                    WHERE oi.order_id = :id
                ");
                $itemsStmt->bindParam(':id', $id);
                $itemsStmt->execute();
                $items = $itemsStmt->fetchAll(PDO::FETCH_ASSOC);
                $orders[0]['items'] = $items;
            }
            
            http_response_code(200);
            echo json_encode(['orders' => $orders]);

        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
        }
        break;

    case 'PUT':
        // Update order status
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (!isset($data['id']) || !isset($data['status'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Order ID and status are required']);
            exit;
        }
        
        // Start transaction
        $db->beginTransaction();
        
        try {
            // Update order status
            $stmt = $db->prepare("UPDATE orders SET status = :status WHERE id = :id");
            $stmt->execute([':status' => $data['status'], ':id' => $data['id']]);
            
            // Get order details for notification
            $stmt = $db->prepare("
                SELECT o.user_id, o.id as order_id, u.name as user_name
                FROM orders o
                JOIN users u ON o.user_id = u.id
                WHERE o.id = :id
            ");
            $stmt->bindParam(':id', $data['id']);
            $stmt->execute();
            $orderDetails = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Send notification to user
            $title = "Order Status Updated";
            $message = "Your order #{$orderDetails['order_id']} has been updated to: {$data['status']}";
            // sendNotification($db, $orderDetails['user_id'], $title, $message, 'order'); // sendNotification needs to be PDO compatible
            
            /*
            // Admin logging disabled during testing
            logAdminAction($db, $admin->id, "Updated order status", [
                'order_id' => $data['id'],
                'new_status' => $data['status']
            ]);
            */
            
            $db->commit();
            http_response_code(200);
            echo json_encode(['message' => 'Order updated successfully']);

        } catch (Exception $e) {
            $db->rollBack();
            http_response_code(500);
            echo json_encode(['error' => 'Failed to update order: ' . $e->getMessage()]);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>