<?php
require_once 'config/cors.php';
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

if ($db) {
    // Test database connection and get some sample data
    try {
        $query = "SELECT COUNT(*) as product_count FROM products WHERE is_active = 1";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $categoryQuery = "SELECT COUNT(*) as category_count FROM categories";
        $categoryStmt = $db->prepare($categoryQuery);
        $categoryStmt->execute();
        $categoryResult = $categoryStmt->fetch(PDO::FETCH_ASSOC);
        
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'message' => 'API is working!',
            'database' => 'Connected',
            'products' => $result['product_count'],
            'categories' => $categoryResult['category_count'],
            'timestamp' => date('Y-m-d H:i:s')
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Database error: ' . $e->getMessage()
        ]);
    }
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database connection failed'
    ]);
}
?>