<?php
require_once 'config/cors.php';
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    // First, let's get a user ID to use for notifications
    $stmt = $db->prepare("SELECT id FROM users LIMIT 1");
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo json_encode(['error' => 'No users found. Please register a user first.']);
        exit;
    }
    
    $userId = $user['id'];
    
    // Add some test notifications
    $notifications = [
        [
            'title' => 'Welcome to Mobile Shop!',
            'message' => 'Thank you for joining our platform. Explore our latest mobile phones and accessories.',
            'type' => 'info'
        ],
        [
            'title' => 'New Product Alert',
            'message' => 'Check out the latest iPhone 15 Pro Max now available in our store!',
            'type' => 'promotion'
        ],
        [
            'title' => 'Order Update',
            'message' => 'Your recent order has been processed and will be shipped soon.',
            'type' => 'success'
        ]
    ];
    
    $insertStmt = $db->prepare("INSERT INTO notifications (user_id, title, message, type, read_status, created_at) VALUES (?, ?, ?, ?, 0, NOW())");
    
    $added = 0;
    foreach ($notifications as $notification) {
        if ($insertStmt->execute([$userId, $notification['title'], $notification['message'], $notification['type']])) {
            $added++;
        }
    }
    
    echo json_encode([
        'success' => true,
        'message' => "Added $added test notifications",
        'user_id' => $userId
    ]);
    
} catch (Exception $e) {
    echo json_encode(['error' => 'Failed to add notifications: ' . $e->getMessage()]);
}
?>