<?php
require_once '../config/cors.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

if ($method !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Get active carousel items
    $stmt = $db->prepare("
        SELECT hc.*, c.name as category_name, p.name as product_name 
        FROM home_carousel hc 
        LEFT JOIN categories c ON hc.category_id = c.id 
        LEFT JOIN products p ON hc.product_id = p.id 
        WHERE hc.status = 'active'
        ORDER BY hc.position ASC
    ");
    
    $stmt->execute();
    $carousels = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'carousels' => $carousels
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>