<?php
require_once 'config/cors.php';
require_once 'config/database.php';

// Test database connection
try {
    $database = new Database();
    $db = $database->getConnection();
    echo json_encode([
        'database_connection' => 'success',
        'message' => 'Database connected successfully'
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'database_connection' => 'failed',
        'error' => $e->getMessage()
    ]);
}

// Test if users table exists
try {
    $stmt = $db->prepare("DESCRIBE users");
    $stmt->execute();
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode([
        'users_table' => 'exists',
        'columns' => array_column($columns, 'Field')
    ]);
} catch (Exception $e) {
    echo json_encode([
        'users_table' => 'error',
        'error' => $e->getMessage()
    ]);
}
?>