<?php
require_once '../config/cors.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

if ($method !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Get user ID from query params
    $userId = $_GET['userId'] ?? $_GET['user_id'] ?? null;

    if (!$userId) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'User ID is required']);
        exit;
    }

    // If guest user, return empty orders
    if ($userId === 'guest') {
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'orders' => []
        ]);
        exit;
    }

    // Get orders with address details
    $stmt = $db->prepare("
        SELECT 
            o.*,
            a.label as address_label,
            a.address_line1,
            a.address_line2,
            a.city,
            a.state,
            a.postal_code,
            a.country
        FROM orders o
        LEFT JOIN addresses a ON o.shipping_address_id = a.id
        WHERE o.user_id = :user_id
        ORDER BY o.created_at DESC
    ");
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
    $stmt->execute();
    
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get order items for each order
    foreach ($orders as &$order) {
        $stmt = $db->prepare("
            SELECT 
                oi.*,
                p.name as product_name,
                p.brand,
                pi.url as image_url
            FROM order_items oi
            JOIN products p ON oi.product_id = p.id
            LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.position = 0
            WHERE oi.order_id = :order_id
        ");
        $stmt->bindParam(':order_id', $order['id'], PDO::PARAM_STR);
        $stmt->execute();
        
        $order['items'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'orders' => $orders
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Internal Server Error: ' . $e->getMessage()
    ]);
}
?>